from reactor_client import DigitalTwinsClientWrapper
import time

adt_url = "https://Br-Twin.api.sea.digitaltwins.azure.net"
dt = DigitalTwinsClientWrapper(adt_url)

# --- Send control signals ---

dt.update_reactor_controls(coolant_flow=0)
time.sleep(5)           

dt.update_reactor_controls(heater_current=50)
time.sleep(5)

dt.update_reactor_controls(heater_current=0)
time.sleep(5)

# --- Read data ---

print("\nReading reactor temperatures...")
temps = dt.get_all_temperatures()

print(f"Reactor Temp (Tr): {temps.get('Tr')}")
print(f"Jacket Temp (Tj): {temps.get('Tj')}")
print(f"Coolant Temp (Tc): {temps.get('Tc')}")
